<?php
/*
 * 파일명: pixabay-modal.php
 * 위치: /wp-content/plugins/image-format-converter/templates/
 * 기능: Pixabay 이미지 검색 모달 템플릿
 * 작성일: 2025-04-21
 */

// 직접 접근 방지
if (!defined('ABSPATH')) {
    exit;
}
?>
<div id="pixabay-modal" class="pixabay-modal">
    <div class="pixabay-modal-content">
        <div class="pixabay-modal-header">
            <span class="pixabay-modal-close">&times;</span>
            <h2>Pixabay 무료 이미지 검색</h2>
        </div>
        
        <div class="pixabay-modal-body">
            <div class="pixabay-search-container">
                <div class="pixabay-search-form">
                    <div class="pixabay-search-input-group">
                        <input type="text" id="pixabay-search-input" placeholder="검색어를 입력하세요...">
                        <button id="pixabay-search-button" class="button button-primary">검색</button>
                    </div>
                    
                    <div class="pixabay-search-filters">
                        <div class="pixabay-filter-group">
                            <label for="pixabay-image-type">이미지 유형:</label>
                            <select id="pixabay-image-type">
                                <option value="photo">사진</option>
                                <option value="illustration">일러스트레이션</option>
                                <option value="vector">벡터 그래픽</option>
                                <option value="all">모든 이미지</option>
                            </select>
                        </div>
                        
                        <div class="pixabay-filter-group">
                            <label for="pixabay-orientation">방향:</label>
                            <select id="pixabay-orientation">
                                <option value="all">모든 방향</option>
                                <option value="horizontal">가로 방향</option>
                                <option value="vertical">세로 방향</option>
                            </select>
                        </div>
                        
                        <div class="pixabay-filter-group">
                            <label for="pixabay-category">카테고리:</label>
                            <select id="pixabay-category">
                                <option value="">카테고리 선택 없음</option>
                                <option value="backgrounds">배경</option>
                                <option value="fashion">패션</option>
                                <option value="nature">자연</option>
                                <option value="science">과학</option>
                                <option value="education">교육</option>
                                <option value="health">건강</option>
                                <option value="people">사람</option>
                                <option value="religion">종교</option>
                                <option value="places">장소</option>
                                <option value="animals">동물</option>
                                <option value="industry">산업</option>
                                <option value="computer">컴퓨터</option>
                                <option value="food">음식</option>
                                <option value="sports">스포츠</option>
                                <option value="transportation">교통</option>
                                <option value="travel">여행</option>
                                <option value="buildings">건물</option>
                                <option value="business">비즈니스</option>
                                <option value="music">음악</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <div class="pixabay-search-results">
                    <div class="pixabay-results-info">
                        <span id="pixabay-results-count"></span>
                    </div>
                    
                    <div id="pixabay-images-container" class="pixabay-images-grid"></div>
                    
                    <div class="pixabay-load-more">
                        <button id="pixabay-load-more-button" class="button button-secondary">더 많은 이미지 불러오기</button>
                    </div>
                    
                    <div id="pixabay-loading" class="pixabay-loading">
                        <span class="spinner is-active"></span>
                        <span class="loading-text">이미지 로딩 중...</span>
                    </div>
                    
                    <div id="pixabay-no-results" class="pixabay-no-results">
                        검색 결과가 없습니다. 다른 검색어로 시도해보세요.
                    </div>
                </div>
            </div>
            
            <div class="pixabay-attribution">
                이미지 제공: <a href="https://pixabay.com/" target="_blank" rel="noopener noreferrer">Pixabay</a>
            </div>
        </div>
    </div>
</div>