/**
 * 파일명: admin-script.js
 * 위치: /wp-content/plugins/image-format-converter/assets/js/
 * 기능: 관리자 설정 페이지 자바스크립트
 * 작성일: 2025-04-21
 */

(function($) {
    'use strict';
    
    // DOM 로드 완료 시
    $(document).ready(function() {
        // 설정 섹션의 의존성 관리
        handleSettingsDependencies();
        
        // 설정 변경 시 의존성 업데이트
        $('.img-manage-admin input, .img-manage-admin select').on('change', function() {
            handleSettingsDependencies();
        });
        
        // 탭 내비게이션 (이미 HTML에 구현되어 있지만 여기서도 추가)
        $('.img-tabs .nav-tab').on('click', function(e) {
            e.preventDefault();
            
            // 탭 활성화
            $('.img-tabs .nav-tab').removeClass('nav-tab-active');
            $(this).addClass('nav-tab-active');
            
            // 탭 내용 표시
            const targetTab = $(this).attr('href');
            $('.tab-content').hide();
            $(targetTab).show();
            
            // 탭 상태 localStorage에 저장
            if (typeof Storage !== 'undefined') {
                localStorage.setItem('img_manage_active_tab', targetTab);
            }
        });
        
        // 마지막으로 선택한 탭 복원
        if (typeof Storage !== 'undefined') {
            const lastTab = localStorage.getItem('img_manage_active_tab');
            if (lastTab) {
                $(`.img-tabs .nav-tab[href="${lastTab}"]`).trigger('click');
            }
        }
        
        // 설정 전체 접기/펼치기 기능
        initCollapseExpandFeatures();
        
        // 툴팁 초기화
        initTooltips();
        
        // 고급 설정 토글
        initAdvancedSettings();
    });
    
    /**
     * 설정 섹션의 의존성 관리
     */
    function handleSettingsDependencies() {
        // PNG 변환 활성화 상태에 따른 설정 표시/숨김
        const pngEnabled = $('#png-enabled').is(':checked');
        if (pngEnabled) {
            $('#png-target').closest('.img-option-row').show();
            $('#png-quality').closest('.img-option-row').show();
        } else {
            $('#png-target').closest('.img-option-row').hide();
            $('#png-quality').closest('.img-option-row').hide();
        }
        
        // JPG 변환 활성화 상태에 따른 설정 표시/숨김
        const jpgEnabled = $('#jpg-enabled').is(':checked');
        if (jpgEnabled) {
            $('#jpg-quality').closest('.img-option-row').show();
        } else {
            $('#jpg-quality').closest('.img-option-row').hide();
        }
        
        // WEBP 변환 활성화 상태에 따른 설정 표시/숨김
        const webpEnabled = $('#webp-enabled').is(':checked');
        if (webpEnabled) {
            $('#webp-quality').closest('.img-option-row').show();
        } else {
            $('#webp-quality').closest('.img-option-row').hide();
        }
        
        // Pixabay 활성화 상태에 따른 설정 표시/숨김
        const pixabayEnabled = $('#pixabay-enabled').is(':checked');
        if (pixabayEnabled) {
            $('#pixabay-default-type').closest('.img-option-row').show();
            $('#pixabay-default-orientation').closest('.img-option-row').show();
            $('#pixabay-default-category').closest('.img-option-row').show();
            $('#pixabay-per-page').closest('.img-option-row').show();
            $('.pixabay-info').show();
        } else {
            $('#pixabay-default-type').closest('.img-option-row').hide();
            $('#pixabay-default-orientation').closest('.img-option-row').hide();
            $('#pixabay-default-category').closest('.img-option-row').hide();
            $('#pixabay-per-page').closest('.img-option-row').hide();
            $('.pixabay-info').hide();
        }
    }
    
    /**
     * 설정 접기/펼치기 기능 초기화
     */
    function initCollapseExpandFeatures() {
        // 카드 타이틀 클릭 시 내용 접기/펼치기
        $('.img-card-title').on('click', function() {
            const $content = $(this).siblings('.img-card-content');
            $content.slideToggle(200);
            $(this).toggleClass('collapsed');
            
            // 접기/펼치기 상태 아이콘 토글
            if ($(this).hasClass('collapsed')) {
                if (!$(this).find('.collapse-icon').length) {
                    $(this).append('<span class="collapse-icon dashicons dashicons-arrow-down-alt2"></span>');
                } else {
                    $(this).find('.collapse-icon').removeClass('dashicons-arrow-up-alt2').addClass('dashicons-arrow-down-alt2');
                }
            } else {
                if (!$(this).find('.collapse-icon').length) {
                    $(this).append('<span class="collapse-icon dashicons dashicons-arrow-up-alt2"></span>');
                } else {
                    $(this).find('.collapse-icon').removeClass('dashicons-arrow-down-alt2').addClass('dashicons-arrow-up-alt2');
                }
            }
        });
        
        // 카드 타이틀에 마우스 오버 시 커서 변경
        $('.img-card-title').css('cursor', 'pointer');
    }
    
    /**
     * 툴팁 초기화
     */
    function initTooltips() {
        // 설정 항목에 도움말 툴팁 추가
        $('.img-option-row label').each(function() {
            const $label = $(this);
            const $description = $label.siblings('.img-desc');
            
            if ($description.length) {
                // 도움말 아이콘 추가
                $label.append(' <span class="help-icon dashicons dashicons-editor-help"></span>');
                
                // 도움말 아이콘에 호버 이벤트 추가
                $label.find('.help-icon').hover(
                    function() {
                        // 툴팁 표시
                        const $tooltip = $('<div class="img-tooltip"></div>');
                        $tooltip.html($description.html());
                        $tooltip.appendTo('body');
                        
                        // 툴팁 위치 설정
                        const offset = $(this).offset();
                        $tooltip.css({
                            top: offset.top + 20,
                            left: offset.left - 100
                        });
                        
                        // 툴팁 표시 애니메이션
                        $tooltip.fadeIn(200);
                    },
                    function() {
                        // 툴팁 제거
                        $('.img-tooltip').remove();
                    }
                );
            }
        });
    }
    
    /**
     * 고급 설정 토글 초기화
     */
    function initAdvancedSettings() {
        // 고급 설정 숨기기
        $('.advanced-setting').hide();
        
        // 고급 설정 토글 버튼 추가
        $('.img-card-content').each(function() {
            const $content = $(this);
            const $advancedSettings = $content.find('.advanced-setting');
            
            if ($advancedSettings.length) {
                const $toggleButton = $('<button type="button" class="button advanced-toggle">고급 설정 표시</button>');
                $content.append($toggleButton);
                
                // 토글 버튼 클릭 이벤트
                $toggleButton.on('click', function() {
                    $advancedSettings.slideToggle(200);
                    
                    if ($(this).text() === '고급 설정 표시') {
                        $(this).text('고급 설정 숨기기');
                    } else {
                        $(this).text('고급 설정 표시');
                    }
                });
            }
        });
    }
    
    /**
     * 설정값 검증 함수
     */
    function validateSettings() {
        let isValid = true;
        
        // 이미지 크기 설정 검증
        const maxWidth = parseInt($('#max-width').val());
        const mediumWidth = parseInt($('#medium-width').val());
        const smallWidth = parseInt($('#small-width').val());
        const thumbnailWidth = parseInt($('#thumbnail-width').val());
        
        if (maxWidth < mediumWidth) {
            alert('최대 가로크기는 중간 가로크기보다 커야 합니다.');
            $('#max-width').focus();
            isValid = false;
        } else if (mediumWidth < smallWidth) {
            alert('중간 가로크기는 작은 가로크기보다 커야 합니다.');
            $('#medium-width').focus();
            isValid = false;
        } else if (smallWidth < thumbnailWidth) {
            alert('작은 가로크기는 썸네일 가로크기보다 커야 합니다.');
            $('#small-width').focus();
            isValid = false;
        }
        
        // 품질 설정 검증
        const pngQuality = parseInt($('#png-quality').val());
        const jpgQuality = parseInt($('#jpg-quality').val());
        const webpQuality = parseInt($('#webp-quality').val());
        
        if (pngQuality < 10 || pngQuality > 100) {
            alert('PNG 압축률은 10에서 100 사이의 값이어야 합니다.');
            $('#png-quality').focus();
            isValid = false;
        } else if (jpgQuality < 10 || jpgQuality > 100) {
            alert('JPG 압축률은 10에서 100 사이의 값이어야 합니다.');
            $('#jpg-quality').focus();
            isValid = false;
        } else if (webpQuality < 10 || webpQuality > 100) {
            alert('WEBP 압축률은 10에서 100 사이의 값이어야 합니다.');
            $('#webp-quality').focus();
            isValid = false;
        }
        
        return isValid;
    }
    
    // 설정 폼 제출 시 유효성 검사
    $('.img-manage-admin form').on('submit', function(e) {
        if (!validateSettings()) {
            e.preventDefault();
        }
    });
    
})(jQuery);